## Document and search field types


Note that it is possible to make a document field
of one type into one or more instances of another search field, by
declaring a field outside the document, which uses other fields as
input. For example, to create an integer attribute for a
string containing a comma-separated list of integers in the document,
do like this:

```
schema example {
    document example {
        field yearlist type string { # Comma-separated years
        }
    }

    field year type array<int> { # Search field using the yearlist value
        indexing: input yearlist | split "," | attribute
    }
}
``` 





[Read more](https://docs.vespa.ai/en/reference/schema-reference.html#document-and-search-field-types)